AddCSLuaFile("cl_init.lua")
AddCSLuaFile("shared.lua")

include("shared.lua");
local MODEL = Model( "models/dav0r/tnt/tnt.mdl" )

function ENT:Initialize()
	self.Entity:SetModel(MODEL);
	self.Entity:PhysicsInit(SOLID_VPHYSICS);
	self.Entity:SetMoveType(MOVETYPE_VPHYSICS);
	self.Entity:SetSolid(SOLID_VPHYSICS);
	self.Damage = 400;
	self.Remove = false;
	self:SetOverlayText("Damage: " .. math.floor(self.Damage));
	self.Entity:SetAngles(self.Entity:GetAngles()+Angle(90,0,0)) -- Add extra pitch - Otherwise, the dynamite stands vertically (looks crappy, trust me)
end

function ENT:OnTakeDamage(dmginfo)
	local c = dmginfo:GetInflictor():GetClass();
	if (c == "gmod_dynamite" or c == "prop_timedexplosion") then return end
	self.Entity:TakePhysicsDamage(dmginfo);
end

function ENT:AcceptInput(n,a,v)
	if(n and n:lower() == "explode") then
		local effectdata = EffectData();
		effectdata:SetOrigin(self.Entity:GetPos());
 		util.Effect("Explosion",effectdata,true,true);
		util.BlastDamage(self.Entity,self.Entity,self.Entity:GetPos(),400,self.Damage); -- Default damage of 100, radius 300 - We need this special funtion here and wont use the gmod_dynamite Explode function, as it removes the SENTs aswell, what we dont want
	end
end

function ENT:KeyValue(k,v)
	if(k == "damage") then
		self.Damage = tonumber(v) or self.Damage;
	end
end
